/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.git.core;

import com.aptana.git.core.GitMoveDeleteHook;
import com.aptana.git.core.GitPlugin;
import com.aptana.git.core.model.IGitRepositoryManager;
import com.aptana.git.internal.core.storage.GitFileHistoryProvider;
import java.net.URI;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.team.IMoveDeleteHook;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.history.IFileHistoryProvider;

public class GitRepositoryProvider
extends RepositoryProvider {
    public static final String ID = GitRepositoryProvider.class.getName();
    private GitFileHistoryProvider historyProvider;

    public void configureProject() throws CoreException {
        IPath dotGitPath;
        URI gitDir;
        this.getProject().refreshLocal(1, (IProgressMonitor)new NullProgressMonitor());
        IResource dotGit = this.getProject().findMember(".git");
        if (dotGit != null && dotGit.exists() && (gitDir = this.getGitRepositoryManager().gitDirForURL(this.getProject().getLocationURI())) != null && (dotGitPath = dotGit.getLocation()) != null && dotGitPath.equals((Object)URIUtil.toPath((URI)gitDir))) {
            dotGit.setTeamPrivateMember(true);
        }
    }

    private IGitRepositoryManager getGitRepositoryManager() {
        return GitPlugin.getDefault().getGitRepositoryManager();
    }

    public String getID() {
        return ID;
    }

    public void deconfigure() {
    }

    public synchronized IFileHistoryProvider getFileHistoryProvider() {
        if (this.historyProvider == null) {
            this.historyProvider = new GitFileHistoryProvider();
        }
        return this.historyProvider;
    }

    public IMoveDeleteHook getMoveDeleteHook() {
        return new GitMoveDeleteHook();
    }
}

